extends AnimatedSprite2D

const snowball = preload("res://Scenes/snowball.tscn")
@onready var progressBar = $ProgressBar
@onready var arrow = $Sprite2D
var angle = 0

# Called when the node enters the scene tree for the first time.
func _ready() -> void:
	progressBar.value = 1
	play("idle")
	pass # Replace with function body.


# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta: float) -> void:
	if Input.is_action_pressed("Up"):
		arrow.rotation_degrees -= 100*delta
		if(arrow.rotation_degrees < -90):
			arrow.rotation_degrees = -90
	if Input.is_action_pressed("Down"):
		arrow.rotation_degrees += 100*delta
		if(arrow.rotation_degrees > 0):
			arrow.rotation_degrees = 0

	
	if Input.is_action_pressed("Charge"):
		progressBar.value += 100*delta
		play("ready")
	elif Input.is_action_just_released("Charge"):
		make_snowball()
		progressBar.value = 0
		play("throw")
		
		
func make_snowball():
	var sb = snowball.instantiate()
	print("prog:",progressBar.value)
	sb.throw(100 + progressBar.value*2, cos(arrow.rotation)*5, sin(arrow.rotation)*5)
	add_child(sb)
		
